#include "LPC15xx.h"

extern   void SCT2_Init(void);

volatile uint32_t numPwmCycles;
volatile int      pwmAborted;
volatile int      pwmPhase;

void SCT2_IRQHandler(void)
{
  uint32_t status = LPC_SCT2->EVFLAG;

    if (status & (1 << 0))                             // event 0 irq?
    {
        ++numPwmCycles;                                // interrupt once per PWM cycle
    }
    if (status & (1 << 5))                             // event 5 irq?
    {
        pwmAborted = 1;                                // Abort interrupt
    }
    LPC_SCT2->EVFLAG = status;                         // clear interrupt flag
}
#define reload_pwm_cycle(value) LPC_SCT->MATCHREL[0].U = value;
#define reload_pwm_val1(value)  LPC_SCT->MATCHREL[1].U = value;
#define reload_pwm_val2(value)  LPC_SCT->MATCHREL[2].U = value;
#define reload_pwm_val3(value)  LPC_SCT->MATCHREL[3].U = value;
#define reload_pwm_val4(value)  LPC_SCT->MATCHREL[4].U = value;

int main (void)
{
  uint32_t lastCycles;

    LPC_SYSCON->SYSAHBCLKCTRL1  |= EN1_SCT_IPU;        // enable SCT_IPU clock
    LPC_SYSCON->SYSAHBCLKCTRL0  |= EN0_SWM    |        // enable SWM clock
                                   EN0_P_MUX;          // enable PMUX clock

    LPC_SWM->PINASSIGN8         |= 0xFF000000;         // ASSIGN8(31:23) = FF
    LPC_SWM->PINASSIGN9         |= 0x0000FFFF;         // ASSIGN9(15:0)  = FFFF
    LPC_SWM->PINASSIGN8         &= 0x18FFFFFF;         // SCT2_OUT0 = P0.24 = green trace  = PWM1
    LPC_SWM->PINASSIGN9         &= 0xFFFF0100;         // SCT2_OUT1 = P0.0  = red trace    = PWM2
                                                       // SCT2_OUT2 = P0.1  = yellow trace = PWM3
    LPC_SWM->PINENABLE1         &= ~(1 << 15);         // SCT2_OUT3 = P0.6  = blue trace   = PWM4

    LPC_SWM->PINASSIGN10        |= 0x0000FF00;         // ASSIGN10(15:8) = FF
    LPC_SWM->PINASSIGN10        &= 0xFFFF45FF;         // P2.5 = SCT_ABORT0
    LPC_SCT_IPU->ABORT[2].ENABLE = 1;                  // enable SCT_ABORT0 from SWM
    LPC_PMUX->SCT2_P_MUX0        = 14;                 // SCT2_IN0 = SCTIPU_ABORT = P2.5 (SW2)

    SCT2_Init();                                       // Initialize SCT0

    while (1)                                          // loop forever
    {
       	if (numPwmCycles != lastCycles)
       	{
            lastCycles = numPwmCycles;
   		    if ((lastCycles % 5) == 0)                 // every few PWM cycles change the duty cycles
   		    {
                LPC_SCT2->CONFIG |= (1 << 7);          // NORELOAD_L (U)
                if (pwmPhase == 0)
                {
                	LPC_SCT2->MATCHREL[1].U = 200000;
                	LPC_SCT2->MATCHREL[3].U = 700000;
                }
                else
                {
                	LPC_SCT2->MATCHREL[1].U = 950000;
                	LPC_SCT2->MATCHREL[3].U = LPC_SCT2->MATCHREL[0].U;	// duty cycle 0 (test conflict resolution)
                }
                LPC_SCT2->CONFIG &= ~(1 << 7);         // NORELOAD_L (U)

                ++pwmPhase;
                if (pwmPhase > 1)
                {
                    pwmPhase = 0;
                }
            }
        }
        if (pwmAborted)          /* Demo: Poll ABORT input, and restart timer if abort condition has gone. */
        {
            while (!(LPC_SCT2->INPUT & (1 << 0))) ;

            LPC_SCT2->CTRL_U &= ~(1 << 2);              /* HALT_L (U) */
            pwmAborted = 0;
        }
    }
}
